// ZombieX by SpookyRobert.... earthquake crash should  be fixed, but I wasn't able 
//to reproduce the crash myself so I can't really test it 

using System;
using System.Collections;
using Server.Items;
using Server.Targeting;
using Server.Network;
using Server.Targets;
using Server.Spells;
using Server.Mobiles;

namespace Server.Mobiles
{
	[CorpseName( "a rotting corpse" )]
	public class Zombiex : BaseCreature
	{

		public override bool CanRegenHits{ get{ return false; } }
		
		public override bool IsScaredOfScaryThings{ get{ return false; } }
		public override bool IsScaryToPets{ get{ return true; } }
		private RotTimer m_Timer;

		[Constructable]
		public Zombiex() : base( AIType.AI_Melee, FightMode.Closest, 20, 1, 0.2, 0.4 )
		{
			Name = "A Contagious Zombie";
			Body = 155;
			BaseSoundID = 471;

			SetStr( 300 );
			SetDex( 25 );
			SetInt( 10 );

			SetHits( 1000 );
			SetStam( 150 );
			SetMana( 0 );

			SetDamage( 10, 15 );

			SetDamageType( ResistanceType.Physical, 25 );
			SetDamageType( ResistanceType.Cold, 25 );
			SetDamageType( ResistanceType.Poison, 50 );

			SetResistance( ResistanceType.Physical, 60, 80 );
			SetResistance( ResistanceType.Fire, 40, 60 );
			SetResistance( ResistanceType.Cold, 99, 100 );
			SetResistance( ResistanceType.Poison, 99, 100 );
			SetResistance( ResistanceType.Energy, 40, 60 );

			SetSkill( SkillName.Poisoning, 120.0 );
			SetSkill( SkillName.MagicResist, 250.0 );
			SetSkill( SkillName.Tactics, 100.0 );
			SetSkill( SkillName.Wrestling, 90.1, 100.0 );

			PassiveSpeed = .4;
			ActiveSpeed = .8;

			Fame = 6000;
			Karma = -6000;

			VirtualArmor = 40;

//Remove timer here to stop decay don't forget the Deserialize timer 
 
			m_Timer = new RotTimer(this);
            		m_Timer.Start();
			
		}
		public override bool OnBeforeDeath()
		{
			m_Timer.Stop();
			return base.OnBeforeDeath();	
		}

		public override void OnMovement( Mobile m, Point3D oldLocation )
		{
			//This finds the mobiles in the area looking for enemys 
			if (!m.Hidden && InRange( m, 20 ) && !InRange( oldLocation, 1 ) && InLOS( m ) && IsEnemy (m) &&  m.AccessLevel < AccessLevel.Counselor )
			{
				this.Combatant = (m);
				
			}
			//This deals with the Zombie's calls to other zombiex's in the area 
			if ( m is Zombiex && this.Combatant != null && InLOS( m ) )
			{
				if ( m.Combatant == null )
				{
					m.Combatant = this.Combatant;
					m.Say ("*Moan*");  // what does the zombie getting called say
					this.Say("*MMooaann*"); // what does the zombie doing the calling say
				}
							
			}
			return;
		
			
			
		}
		public override bool IsEnemy( Mobile m )
		{
			//What should the zombie not Attack? figured the not attack list would be smaller than an attack list
			if ( m is Zombiex || m is AncientLich || m is Bogle || m is LichLord || m is Shade || m is Spectre || m is Wraith || m is BoneKnight || m is Ghoul || m is Mummy || m is SkeletalKnight || m is Skeleton || m is Zombie || m is ShadowKnight || m is DarknightCreeper || m is RevenantLion || m is LadyOfTheSnow || m is RottingCorpse || m is SkeletalDragon || m is Lich ) 
				return false;


			
				return true;
		
			
		}
		public override void OnGotMeleeAttack( Mobile attacker )
		{
			
			if ( this.HitsMaxSeed < 10 )
			{
				this.HitsMaxSeed = 10;
			}
			if ( this.Hits < this.HitsMax / 4 )
			{
				this.CantWalk = true; 
			}
			if ( attacker is PlayerMobile )
			{
				
				switch ( Utility.Random( 2 ) )
				{
					case 0: this.Str -= 1; 
						//this.Say(" losing 1 Str from getting hit"); 
						break;
					//case 1: this.HitsMaxSeed -= Utility.RandomMinMax(1,10); break; 
				
					 
				}	
			}
			
		}
		public override void OnGaveMeleeAttack( Mobile defender )
		{
			base.OnGaveMeleeAttack( defender );
			
			
			if ( defender is PlayerMobile )
			{

				if ( defender.Hits < 10 )
				{
					Zombiex zomb = new Zombiex();
					
					zomb.Map = defender.Map;
					zomb.Female = defender.Female;
					zomb.Body = defender.Body;
					zomb.Location = defender.Location;
					zomb.Hue = 768;
					zomb.Name = defender.Name;
					zomb.Title = "*Infected*";
					
					
					defender.Kill();
					new Zombiex();
					
				}
				switch ( Utility.Random( 2 ) )
				{
					case 0: this.Str -= 1; 
					//this.Say(" losing 1 Str from hitting"); 
					break;
					
				}	
			}
			if ( defender is BaseCreature )
			{
				switch ( Utility.Random( 4 ) )
				{
					case 0: this.Str -= 1;
						//this.Say(" losing 1 Str from hitting"); 
						break;
					
				}
			}
		}

		private class RotTimer : Timer
		{
			private Mobile m_Mobile;

//Change timespan to change the rate of decay 

			public RotTimer( Mobile m ) : base( TimeSpan.FromMinutes( 1.0 ) )
			{
				m_Mobile = m;
				
			}

			protected override void OnTick()
			{
				
				RotTimer rotTimer = new RotTimer( m_Mobile );
				if ( m_Mobile.Str < 2 )
				{
					m_Mobile.Kill();
					Stop();
				}
				else
				{
					if ( m_Mobile.Hits > m_Mobile.HitsMax / 2 ) 
					{
						m_Mobile.Hits -= m_Mobile.HitsMax / 100;
						//m_Mobile.Say(" losing 1% Hits");
					}
						
					if ( m_Mobile.Hits <= m_Mobile.HitsMax / 2 )
					{ 
						m_Mobile.Hits -= 1;
						//m_Mobile.Say(" losing 1 Hitpoint");
					}
					if ( m_Mobile.Hits < m_Mobile.HitsMax / 4 )  
					{
						m_Mobile.CantWalk = true;
						//m_Mobile.Say(" Cant Walk Anymore");
						 
					}  
					
					if ( m_Mobile.Str > 100 )
					{ 
						m_Mobile.Str -= m_Mobile.Str / 30;
						//m_Mobile.Say(" losing 3.33% Str");
					}
					if ( m_Mobile.Str <= 100 )
					{ 
						m_Mobile.Str -= 1;
						//m_Mobile.Say(" losing 1 Str point");
					}
					
					

					rotTimer.Start();
				}
			}
		}
		public override bool AlwaysMurderer{ get{ return true; } }

		public override bool BleedImmune{ get{ return true; } }
		public override Poison PoisonImmune{ get{ return Poison.Lethal; } }
		public override Poison HitPoison{ get{ return Poison.Lethal; } }
		public virtual bool CanRummageCorpses{ get{ return true; } }

		
		

		public Zombiex( Serial serial ) : base( serial )
		{
		}
		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );
			
		}
		

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();

//Remove timer here to stop decay but don't forget the one Constructable section!

			m_Timer = new RotTimer(this);
            		m_Timer.Start();
		}
	}
}